package editor;

import game.CustomImageDataII;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class CustomAnimationPreviewPopupPane extends JPanel implements Runnable {

	private ListModel listModel;
	private int currentFrame;
	private boolean shouldNotStop = true;
	private ListedCustomImage imageArray[] = null;
	private Image backdropImage = null;
	
	public CustomAnimationPreviewPopupPane(ListModel theListModel, Image theBackdrop) {
		listModel = theListModel;
		shouldNotStop = true;
		currentFrame = 0;
		backdropImage = theBackdrop;
		
		ListedCustomImage li = null;
		BufferedImage tempImage = null;
		imageArray = new ListedCustomImage[listModel.getSize()];
		
		for(int i = 0; i < listModel.getSize(); i++) {
			
			if(listModel.getElementAt(i) instanceof ListedOverlayImage) {
				
				li = (ListedOverlayImage) listModel.getElementAt(i);
				
				tempImage = li.getImage();
				
				if(li.getTransparentColor() != null) {
					Color adjustedTransparentColor = new Color(li.getTransparentColor().getRed(), li.getTransparentColor().getGreen(), li.getTransparentColor().getBlue(), ((ListedOverlayImage)li).getTransparency());
					tempImage = CustomImageDataII.makeImageTransparent(tempImage, adjustedTransparentColor);//tempImage = CustomImageData.makeColorTransparent(tempImage, li.getTransparentColor());
				}
				imageArray[i] = new ListedOverlayImage(tempImage, li.getDesiredWidth(), li.getDesiredHeight(), li.getTransparentColor(), li.getObserver(), li.getFileName());
				((ListedOverlayImage) imageArray[i]).setTransparency(((ListedOverlayImage)li).getTransparency());
				
				
			} else {
			
				li = (ListedCustomImage) listModel.getElementAt(i);
				
				tempImage = li.getImage();
				tempImage = CustomImageDataII.makeImageTransparent(tempImage, li.getTransparentColor());
				
				imageArray[i] = new ListedCustomImage(tempImage, li.getDesiredWidth(), li.getDesiredHeight(), li.getTransparentColor(), li.getObserver(), li.getFileName());
			}
		}
		
		
		this.setSize(500, 500);
	}

	public void run() {
		
		while(shouldNotStop) {
			
			repaint();
			
			try {
				Thread.sleep(100L);
			} catch (InterruptedException e) {
				
			}
			
		}
		
		this.backdropImage = null;
		this.imageArray = null;
		this.listModel = null;
		
	}
	
	public void paintComponent(Graphics g) {
		
		ListedCustomImage li = imageArray[currentFrame];
		
		
		int newX, newY, newWidth, newHeight;
		
		if(li.getDesiredHeight() <= 500 || li.getDesiredWidth() <= 500) {
			
			newX = 500 / 2 - li.getDesiredWidth() / 2;
			newY = 500 / 2 - li.getDesiredHeight() / 2;
			newWidth = li.getDesiredWidth();
			newHeight = li.getDesiredHeight();
			
		} else {
			
			if(li.getDesiredHeight() > li.getDesiredWidth()) {
				
				newHeight = 500;
				newWidth = (int) (500 * ((double) li.getDesiredWidth() / (double) li.getDesiredHeight()));
				
				newY = 0;
				newX = 500 / 2 - newWidth / 2;
				
			} else {
				
				newWidth = 500;
				newHeight = (int) (500 * ((double) li.getDesiredHeight() / (double) li.getDesiredWidth()));
				
				newX = 0;
				newY = 500 / 2 - newHeight / 2;
				
			}
			
			
		}
		
		
		
		
//		while(!Toolkit.getDefaultToolkit().prepareImage(li.getImage(), newWidth, newHeight, this));
		
		g.drawImage(this.backdropImage, 0, 0, 500, 500, this);
		
		Composite composite = null;
		
		
		if(g instanceof Graphics2D && li instanceof ListedOverlayImage) {
//			System.out.println("                                                      it's a 2d, all right!!  Transparency:  " + (1.0f * ((ListedOverlayImage) li).getTransparency() / 255.0f));
			
			composite = ((Graphics2D) g).getComposite();
			
			((Graphics2D)g).setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, ((ListedOverlayImage) li).getTransparency() / 255.0f));
			
			
		} else {
//			System.out.println("                                                      no luck...sorry:  " + li.getClass().getCanonicalName());
		}
		
		g.drawImage(li.getImage(), newX, newY, newWidth, newHeight, this);
		
		if(g instanceof Graphics2D && li instanceof ListedOverlayImage) {
			((Graphics2D) g).setComposite(composite);
		}
		
		
		currentFrame++;
		
		if(currentFrame >= listModel.getSize()) {
			currentFrame = 0;
		}
		
	}
	
	public void stopCycling() {
		shouldNotStop = false;
	}
	
	public static void showPopUp(ListModel theListModel, Image backdrop) {
		
		
		final CustomAnimationPreviewPopupPane panel = new CustomAnimationPreviewPopupPane(theListModel, backdrop);
		
		JDialog theFrame = new JDialog();
		
		theFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				panel.stopCycling();
			}
		});
		
		theFrame.setSize(508, 534);
		
		theFrame.setContentPane(panel);
		theFrame.setModal(true);

		Thread thread = new Thread(panel);
		thread.start();
		
		theFrame.setVisible(true);
		
		
		theFrame.dispose();
		
		
		
		
	}
	

}
